#ifndef __c4d_plugin_h__
#define __c4d_plugin_h__

#ifdef WIN32
	#ifndef __PC
		#define __PC
	#endif
#else
	#ifdef __POWERPC__
		#ifndef __MAC
			#define __MAC
		#endif
	#else
		#error "Unsupported OS"
	#endif
#endif


#include "ge_math.h"

#define C4DPL_VERSION 0x0002

// error
#define C4DPL_ERROR					-1
#define C4DPL_ERROR_TYPE		-2
#define C4DPL_ERROR_VERSION	-3
#define C4DPL_ERROR_OS			-4
#define C4DPL_ERROR_MEM			-5

// action
#define C4DPL_INIT_SYS			 1
#define C4DPL_INIT					 2
#define C4DPL_END						 3
#define C4DPL_INIT_VERSION	 4
#define C4DPL_MESSAGE				 6

#define C4DMSG_PRIORITY			 0
#define C4DMSG_OS						 1

// priorities
#define C4DPL_INIT_PRIORITY_XTENSIONS				20000
#define C4DPL_INIT_PRIORITY_OBJECTS					19000
#define C4DPL_INIT_PRIORITY_SHADER					18000
#define C4DPL_INIT_PRIORITY_ADVANCEDRENDER	17000

#define C4DPL_INIT_PRIORITY_MODULES		 10000
#define C4DPL_INIT_PRIORITY_PLUGINS				 0

// messages
#define C4DPL_STARTACTIVITY		1000
#define C4DPL_ENDACTIVITY			1001

// the interface
Bool PluginStart(void);
void PluginEnd(void);
Bool PluginMessage(LONG id, void *data);

static void SetPluginPriority(void *data, LONG i) { *((LONG*)data)=i; }

#endif
